using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using ITA106;

namespace MapowanieCieni
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Prostopadloscian szescian, podloze, prostopadloscian;
        Model czajnik;

        Matrix transformacjeSzescianu = Matrix.Identity;
        Matrix transformacjeCzajnika = Matrix.CreateScale(0.55f);
        BasicEffect efekt;
        Matrix View, Projection;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            //inicjacja efektu w metodzie LoadContent, bo pozniej efekt bedzie wczytywany z pliku
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;
            efekt.EnableDefaultLighting();
            efekt.World = Matrix.Identity;

            View = Matrix.CreateLookAt(new Vector3(0, 0, 2.5f), new Vector3(0, 0, 0), new Vector3(0, 1, 0));
            Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 100.0f);
            efekt.View = View;
            efekt.Projection = Projection;

            //obiekty
            szescian = new Prostopadloscian(this, efekt, 1, 1, 1, Color.Chocolate);
            podloze = new Prostopadloscian(this, efekt, 7, 0.1f, 5, Color.Green);
            podloze.World = Matrix.CreateTranslation(0, -1.75f, -2);
            prostopadloscian = new Prostopadloscian(this, efekt, 3, 0.5f, 1, Color.Yellow);
            prostopadloscian.World = Matrix.CreateTranslation(-1.5f, -1.5f, -2);

            czajnik = Content.Load<Model>("teapot");
            foreach (var siatka in czajnik.Meshes)
            {
                foreach (var part in siatka.MeshParts)
                {
                    part.Effect = efekt.Clone();
                    ((BasicEffect)part.Effect).VertexColorEnabled = false;
                }
            }            
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            transformacjeSzescianu *= Matrix.CreateRotationX(0.01f) * Matrix.CreateRotationY(0.01f);            
            transformacjeCzajnika *= Matrix.CreateRotationY(0.01f);

            KeyboardState stanKlawiatury = Keyboard.GetState();

            bool obrotyKamery=stanKlawiatury.GetPressedKeys().Count()>0;
            if(obrotyKamery)
            {
                View *= Matrix.CreateTranslation(new Vector3(0, 1.5f, 2.5f));
            }
            if (stanKlawiatury.IsKeyDown(Keys.Up)) View *= Matrix.CreateRotationX(0.05f);
            if (stanKlawiatury.IsKeyDown(Keys.Down)) View *= Matrix.CreateRotationX(-0.05f);
            if (stanKlawiatury.IsKeyDown(Keys.Left)) View *= Matrix.CreateRotationY(0.05f);
            if (stanKlawiatury.IsKeyDown(Keys.Right)) View *= Matrix.CreateRotationY(-0.05f);
            if (obrotyKamery)
            {
                View *= Matrix.CreateTranslation(new Vector3(0, -1.5f, -2.5f));
                efekt.View = View;                
                foreach (ModelMesh siatka in czajnik.Meshes)
                {
                    foreach (Effect efekt1 in siatka.Effects)
                    {
                        ((BasicEffect)efekt1).View = View;
                    }
                    siatka.Draw();
                }
            }

            if (stanKlawiatury.IsKeyDown(Keys.Escape)) this.Exit();

            poprzedniStanKlawiatury = stanKlawiatury;
            

            base.Update(gameTime);
        }

        protected void Rysuj(GraphicsDevice gd,GameTime gameTime)
        {
            foreach (EffectPass p in efekt.CurrentTechnique.Passes)
            {
                efekt.World = transformacjeSzescianu;
                p.Apply();
                szescian.Rysuj(gameTime, efekt);

                efekt.World = Matrix.CreateTranslation(0, -1.75f, -2);
                p.Apply();
                podloze.Rysuj(gameTime, efekt);
                
                efekt.World = Matrix.CreateTranslation(-1.5f, -1.5f, -2);
                p.Apply();
                prostopadloscian.Rysuj(gameTime, efekt);
            }

            //gd.VertexDeclaration = new VertexDeclaration(gd, VertexPositionColorNormal.VertexElements);
            Matrix[] transformacje = new Matrix[czajnik.Bones.Count];
            czajnik.CopyAbsoluteBoneTransformsTo(transformacje);
            foreach (ModelMesh siatka in czajnik.Meshes)
            {
                foreach (Effect efekt1 in siatka.Effects)
                {
                    ((BasicEffect)efekt1).World=
                       transformacje[siatka.ParentBone.Index] *
                       transformacjeCzajnika *
                       Matrix.CreateTranslation(1.5f, 0, 0);
                }
                siatka.Draw();
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice gd = graphics.GraphicsDevice;

            gd.Clear(Color.Black);
            Rysuj(gd,gameTime);

            base.Draw(gameTime);
        }
    }
}
